#include <node.h>
#include <uv.h>
#include "face.h"
#include <functional>

namespace FaceDetection
{

    using namespace v8;
    using v8::Function;
    using v8::FunctionCallbackInfo;
    using v8::Isolate;
    using v8::HandleScope;
    using v8::Local;
    using v8::Null;
    using v8::Symbol;
    using v8::Object;
    using v8::String;
    using v8::Number;
    using v8::Value;
    using namespace std;

    Handle<Function> cb;
    uv_thread_t texample_thread;


    uv_async_t faceCheckAsyncToken;
    uv_async_t faceSaveAsyncToken;

    uv_loop_t *loop = uv_default_loop();

    struct faceRequest
    {
        Persistent<Function> callback;
        Isolate *isolate;
        string filename;
        cv::Mat frame;
        int result;
    };

    FaceDetector *faceDetector = new FaceDetector();

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    ///
    /// \param req
    void AfterSave(uv_async_t *req)
    {
        auto request = (faceRequest *) req->data;
        auto isolate = request->isolate;
        HandleScope scope(isolate);
        const unsigned argc = 1;
        Local<Value> argv[argc] = {Number::New(isolate, request->result)};
        Local<Function>::New(isolate, request->callback)->
                Call(isolate->GetCurrentContext()->Global(), 1, argv);
    }

    ///
    /// \param req
    void SaveWorker(void *)
    {
        faceDetector->SaveFace("testFace");
        uv_async_send(&faceSaveAsyncToken);
    }

    ///
    /// \param args
    void Save(const FunctionCallbackInfo<Value> &args)
    {
        Isolate *isolate = args.GetIsolate();
        faceRequest *request = new faceRequest();
        cb = Local<Function>::Cast(args[0]);


        request->callback.Reset(isolate, cb);
        request->isolate = isolate;
        faceSaveAsyncToken.data = request;
        uv_async_init(loop, &faceSaveAsyncToken, AfterSave);
        uv_thread_create(&texample_thread, SaveWorker, NULL);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    ///
    /// \param req
    void AfterCheck(uv_async_t *req)
    {
        auto request = (faceRequest *) req->data;
        auto isolate = request->isolate;
        HandleScope scope(isolate);
        const unsigned argc = 1;
        Local<Value> argv[argc] = {Number::New(isolate, request->result)};
        Local<Function>::New(isolate, request->callback)->
                Call(isolate->GetCurrentContext()->Global(), 1, argv);
    }

    ///
    /// \param req
    void CheckWorker(void *)
    {
        int res = faceDetector->CheckFace("testFace");
        auto request = (faceRequest *) faceCheckAsyncToken.data;
        request->result=res;
        uv_async_send(&faceCheckAsyncToken);
    }

    ///
    /// \param args
    void Check(const FunctionCallbackInfo<Value> &args)
    {
        Isolate *isolate = args.GetIsolate();
        faceRequest *request = new faceRequest();
        cb = Local<Function>::Cast(args[0]);
        request->callback.Reset(isolate, cb);
        request->isolate = isolate;

        faceCheckAsyncToken.data = request;

        uv_async_init(loop, &faceCheckAsyncToken, AfterCheck);
        uv_thread_create(&texample_thread, CheckWorker, NULL);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    ///
    /// \param args
    void SetWorkingDir(const FunctionCallbackInfo<Value> &args)
    {
        v8::String::Utf8Value param1(args[0]->ToString());
        std::string foo = std::string(*param1);
        faceDetector->Init(foo);
    }

    ///
    /// \param args
    void Start(const FunctionCallbackInfo<Value> &args)
    {
        Isolate *isolate = args.GetIsolate();
        faceRequest *request = new faceRequest();
        cb = Local<Function>::Cast(args[0]);
        request->callback.Reset(isolate, cb);
        request->isolate = isolate;

        faceCheckAsyncToken.data = request;

        uv_async_init(loop, &faceCheckAsyncToken, [](uv_async_t* req){
            auto request = (faceRequest *) req->data;
            auto isolate = request->isolate;
            auto frame=request->frame;
            HandleScope scope(isolate);

            v8::Local<Array> myArray = v8::Array::New(isolate);

            for(int i=0;i<frame.rows;i++)
            {
                Local<Array> row = Array::New(isolate);
                row->Set(0,Number::New(isolate,frame.at<float>(i,0)));
                row->Set(1,Number::New(isolate,frame.at<float>(i,1)));
                row->Set(2,Number::New(isolate,frame.at<float>(i,2)));
                myArray->Set(i,row);
            }

            const unsigned argc = 1;
            Local<Value> argv[argc] = {myArray};
            Local<Function>::New(isolate, request->callback)->
                    Call(isolate->GetCurrentContext()->Global(), argc, argv);
        });
        uv_thread_create(&texample_thread, [](void*){
            faceDetector->Start([](cv::Mat mat){
                printf("lol, callback\n");
                uv_async_send(&faceCheckAsyncToken);
            });
        }, NULL);
    }

    void Stop(const FunctionCallbackInfo<Value> &args)
    {
    }

    void init(Local<Object> exports, Local<Object> module)
    {
        NODE_SET_METHOD(exports, "saveFace", Save);
        NODE_SET_METHOD(exports, "checkFace", Check);
        NODE_SET_METHOD(exports, "start", Start);
        NODE_SET_METHOD(exports, "stop", Stop);
        NODE_SET_METHOD(exports, "setWorkingDir", SetWorkingDir);
    }

    NODE_MODULE(addon, init)
}